<?php $__env->startSection('content'); ?>
    <div class="page-container">

        <div class="page-title-head d-flex align-items-sm-center flex-sm-row flex-column gap-2">
            <div class="flex-grow-1">
                <h4 class="fs-18 fw-semibold mb-0"><?php echo e($title); ?></h4>
            </div>

            <div class="text-end">
                <?php if (isset($component)) { $__componentOriginalf249638ac7504c50bf0259c0cb71919d = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalf249638ac7504c50bf0259c0cb71919d = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.dashboard.user.breadcrumbs','data' => ['breadcrumbs' => $breadcrumbs]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('dashboard.user.breadcrumbs'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['breadcrumbs' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($breadcrumbs)]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalf249638ac7504c50bf0259c0cb71919d)): ?>
<?php $attributes = $__attributesOriginalf249638ac7504c50bf0259c0cb71919d; ?>
<?php unset($__attributesOriginalf249638ac7504c50bf0259c0cb71919d); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalf249638ac7504c50bf0259c0cb71919d)): ?>
<?php $component = $__componentOriginalf249638ac7504c50bf0259c0cb71919d; ?>
<?php unset($__componentOriginalf249638ac7504c50bf0259c0cb71919d); ?>
<?php endif; ?>
            </div>
        </div>

        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-body p-4">

                        <!-- Transfer Summary -->
                        <h4 class="fw-bold mb-3">Please confirm your transfer details</h4>
                        <div class="mb-3">
                            <strong>Transfer Type:</strong>
                            <p class="mb-0 text-muted"><?php echo e($transfer->transfer_type->fullLabel()); ?></p>
                        </div>

                        <div class="mb-3">
                            <strong>Beneficiary Name:</strong>
                            <p class="mb-0 text-muted"><?php echo e($transfer->recipient_name); ?></p>
                        </div>

                        <div class="mb-3">
                            <strong>Beneficiary Account:</strong>
                            <p class="mb-0 text-muted"><?php echo e($transfer->recipient_account_number); ?></p>
                        </div>

                        <div class="mb-3">
                            <strong>Bank:</strong>
                            <p class="mb-0 text-muted"><?php echo e($transfer->recipient_bank); ?></p>
                        </div>

                        <?php if($transfer->recipient_swift_code): ?>
                            <div class="mb-3">
                                <strong>SWIFT Code:</strong>
                                <p class="mb-0 text-muted"><?php echo e($transfer->recipient_swift_code); ?></p>
                            </div>
                        <?php endif; ?>
                        <?php if($transfer->recipient_iban_code): ?>
                            <div class="mb-3">
                                <strong>IBAN Number:</strong>
                                <p class="mb-0 text-muted"><?php echo e($transfer->recipient_iban_code); ?></p>
                            </div>
                        <?php endif; ?>
                        <?php if($transfer->recipient_routing_number): ?>
                            <div class="mb-3">
                                <strong>Routing Number:</strong>
                                <p class="mb-0 text-muted"><?php echo e($transfer->recipient_routing_number); ?></p>
                            </div>
                        <?php endif; ?>

                        <div class="mb-3">
                            <strong>Amount:</strong>
                            <p class="mb-0 fw-bold">
                                <?php echo e(currency($user->currency)); ?><?php echo e(formatAmount($transfer->amount)); ?>

                            </p>
                        </div>

                        

                        <div class="mb-3">
                            <strong>Description:</strong>
                            <p class="mb-0 text-muted"><?php echo e($transfer->description); ?></p>
                        </div>

                        <!-- Action Buttons -->
                        <div class="d-flex justify-content-between mt-4">
                            <a href="<?php echo e(route('user.transfer.cancel', $transfer->uuid)); ?>"
                                onclick="return confirm('Are you sure you want to cancel this transfer?')"
                                class="btn btn-outline-danger btn-lg rounded-pill">
                                <i class="bi bi-x-circle me-1"></i> Cancel
                            </a>
                            <?php if(!$user->shouldTransferFail()): ?>
                                <?php if($transferNeedVerificationCode): ?>
                                    <a href="<?php echo e(route('user.transfer.verify', [$transfer->uuid, $orderNo])); ?>"
                                        class="btn btn-success btn-lg rounded-pill">
                                        <i class="bi bi-check2-circle me-1"></i> Confirm Transfer
                                    </a>
                                <?php else: ?>
                                    <a href="<?php echo e(route('user.transfer.complete', $transfer->uuid)); ?>"
                                        class="btn btn-success btn-lg rounded-pill">
                                        <i class="bi bi-check2-circle me-1"></i> Confirm Transfer
                                    </a>
                                <?php endif; ?>
                            <?php else: ?>
                                <a href="<?php echo e(route('user.transfer.fail', $transfer->uuid)); ?>"
                                    class="btn btn-success btn-lg rounded-pill">
                                    <i class="bi bi-check2-circle me-1"></i> Confirm Transfer
                                </a>
                            <?php endif; ?>
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('dashboard.user.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\projects\online-banking-v7.0\resources\views/dashboard/user/transfer/preview.blade.php ENDPATH**/ ?>