<!-- Rates Section -->
<section
    class="relative py-16 lg:py-20 bg-gradient-to-br from-slate-50 via-white to-primary-50 dark:from-gray-900 dark:via-gray-800 dark:to-primary-900/20 overflow-hidden">
    <!-- Background Elements -->
    <div class="absolute inset-0 opacity-30">
        <div
            class="absolute top-20 left-10 w-72 h-72 bg-primary-200 dark:bg-primary-800 rounded-full blur-3xl animate-pulse">
        </div>
        <div
            class="absolute bottom-20 right-10 w-96 h-96 bg-teal-200 dark:bg-teal-800 rounded-full blur-3xl animate-pulse delay-1000">
        </div>
    </div>

    <div class="relative z-10 max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <!-- Section Header -->
        <div class="text-center mb-12 lg:mb-16">
            <div
                class="inline-flex items-center px-4 py-2 bg-gradient-to-r from-primary-100 to-primary-200 dark:from-primary-900/50 dark:to-primary-800/50 text-primary-700 dark:text-primary-300 rounded-full text-sm font-semibold mb-4 shadow-lg backdrop-blur-sm border border-primary-200/50 dark:border-primary-700/50">
                <i class="fa-solid fa-chart-line mr-2 animate-pulse"></i>
                <?php echo e(config('app.name')); ?> Rates
            </div>
            <h2
                class="text-3xl sm:text-4xl lg:text-5xl font-bold bg-gradient-to-r from-gray-900 via-primary-800 to-gray-900 dark:from-white dark:via-primary-300 dark:to-white bg-clip-text text-transparent mb-4">
                <?php echo e(config('app.name')); ?> Member Care
            </h2>
            <p class="text-lg text-gray-600 dark:text-gray-300 max-w-2xl mx-auto">
                Discover competitive rates designed to help your money grow faster
            </p>
        </div>

        <!-- Rates Grid -->
        <div class="grid sm:grid-cols-2 lg:grid-cols-4 gap-6 lg:gap-8">
            <!-- High Yield Savings -->
            <div
                class="group relative bg-white/80 dark:bg-gray-800/80 backdrop-blur-sm rounded-2xl p-6 shadow-xl hover:shadow-2xl transition-all duration-500 hover:-translate-y-3 border border-gray-200/50 dark:border-gray-700/50 hover:border-primary-300/50 dark:hover:border-primary-600/50 overflow-hidden">
                <!-- Card Glow Effect -->
                <div
                    class="absolute inset-0 bg-gradient-to-br from-primary-500/10 via-transparent to-blue-500/10 opacity-0 group-hover:opacity-100 transition-opacity duration-500">
                </div>

                <div class="relative z-10">
                    <div
                        class="flex items-center justify-center w-16 h-16 bg-gradient-to-br from-primary-100 to-primary-200 dark:from-primary-900/50 dark:to-primary-800/50 rounded-2xl mb-6 group-hover:scale-110 group-hover:rotate-6 transition-all duration-300 shadow-lg">
                        <i class="fa-solid fa-piggy-bank text-xl text-primary-600 dark:text-primary-400"></i>
                    </div>
                    <div class="text-center">
                        <div
                            class="text-3xl lg:text-4xl font-bold bg-gradient-to-r from-primary-600 to-blue-600 dark:from-primary-400 dark:to-blue-400 bg-clip-text text-transparent mb-2">
                            3.75%</div>
                        <div class="text-sm text-gray-500 dark:text-gray-400 mb-3 font-medium">APY*</div>
                        <div class="font-bold text-gray-900 dark:text-white mb-2 text-sm">HIGH YIELD SAVINGS
                        </div>
                        <div class="text-xs text-gray-600 dark:text-gray-400 leading-relaxed">High Yield
                            Savings Rate</div>
                    </div>
                    <div class="mt-4 text-center">
                        <span
                            class="inline-flex items-center px-3 py-1.5 bg-gradient-to-r from-blue-100 to-blue-200 dark:from-blue-900/30 dark:to-blue-800/30 text-blue-700 dark:text-blue-400 rounded-full text-xs font-bold shadow-sm">
                            <i class="fa-solid fa-star mr-1 animate-pulse"></i>
                            FEATURED
                        </span>
                    </div>
                </div>
            </div>

            <!-- Certificate -->
            <div
                class="group relative bg-white/80 dark:bg-gray-800/80 backdrop-blur-sm rounded-2xl p-6 shadow-xl hover:shadow-2xl transition-all duration-500 hover:-translate-y-3 border border-gray-200/50 dark:border-gray-700/50 hover:border-teal-300/50 dark:hover:border-teal-600/50 overflow-hidden">
                <!-- Card Glow Effect -->
                <div
                    class="absolute inset-0 bg-gradient-to-br from-teal-500/10 via-transparent to-green-500/10 opacity-0 group-hover:opacity-100 transition-opacity duration-500">
                </div>

                <div class="relative z-10">
                    <div
                        class="flex items-center justify-center w-16 h-16 bg-gradient-to-br from-teal-100 to-teal-200 dark:from-teal-900/50 dark:to-teal-800/50 rounded-2xl mb-6 group-hover:scale-110 group-hover:rotate-6 transition-all duration-300 shadow-lg">
                        <i class="fa-solid fa-certificate text-xl text-teal-600 dark:text-teal-400"></i>
                    </div>
                    <div class="text-center">
                        <div
                            class="text-3xl lg:text-4xl font-bold bg-gradient-to-r from-teal-600 to-green-600 dark:from-teal-400 dark:to-green-400 bg-clip-text text-transparent mb-2">
                            3.65%</div>
                        <div class="text-sm text-gray-500 dark:text-gray-400 mb-3 font-medium">APY*</div>
                        <div class="font-bold text-gray-900 dark:text-white mb-2 text-sm">18 MONTH CERTIFICATE
                        </div>
                        <div class="text-xs text-gray-600 dark:text-gray-400 leading-relaxed"><?php echo e(config('app.name')); ?>

                            Certificate Rates</div>
                    </div>
                    <div class="mt-4 text-center">
                        <span
                            class="inline-flex items-center px-3 py-1.5 bg-gradient-to-r from-teal-100 to-teal-200 dark:from-teal-900/30 dark:to-teal-800/30 text-teal-700 dark:text-teal-400 rounded-full text-xs font-bold shadow-sm">
                            <i class="fa-solid fa-coins mr-1"></i>
                            SAVINGS
                        </span>
                    </div>
                </div>
            </div>

            <!-- Credit Card -->
            <div
                class="group relative bg-white/80 dark:bg-gray-800/80 backdrop-blur-sm rounded-2xl p-6 shadow-xl hover:shadow-2xl transition-all duration-500 hover:-translate-y-3 border border-gray-200/50 dark:border-gray-700/50 hover:border-purple-300/50 dark:hover:border-purple-600/50 overflow-hidden">
                <!-- Card Glow Effect -->
                <div
                    class="absolute inset-0 bg-gradient-to-br from-purple-500/10 via-transparent to-pink-500/10 opacity-0 group-hover:opacity-100 transition-opacity duration-500">
                </div>

                <div class="relative z-10">
                    <div
                        class="flex items-center justify-center w-16 h-16 bg-gradient-to-br from-purple-100 to-purple-200 dark:from-purple-900/50 dark:to-purple-800/50 rounded-2xl mb-6 group-hover:scale-110 group-hover:rotate-6 transition-all duration-300 shadow-lg">
                        <i class="fa-solid fa-credit-card text-xl text-purple-600 dark:text-purple-400"></i>
                    </div>
                    <div class="text-center">
                        <div
                            class="text-3xl lg:text-4xl font-bold bg-gradient-to-r from-purple-600 to-pink-600 dark:from-purple-400 dark:to-pink-400 bg-clip-text text-transparent mb-2">
                            4.00%</div>
                        <div class="text-sm text-gray-500 dark:text-gray-400 mb-3 font-medium">APR*</div>
                        <div class="font-bold text-gray-900 dark:text-white mb-2 text-sm">CREDIT CARDS</div>
                        <div class="text-xs text-gray-600 dark:text-gray-400 leading-relaxed"><?php echo e(config('app.name')); ?>

                            Credit Card Rates</div>
                    </div>
                    <div class="mt-4 text-center">
                        <span
                            class="inline-flex items-center px-3 py-1.5 bg-gradient-to-r from-purple-100 to-purple-200 dark:from-purple-900/30 dark:to-purple-800/30 text-purple-700 dark:text-purple-400 rounded-full text-xs font-bold shadow-sm">
                            <i class="fa-solid fa-credit-card mr-1"></i>
                            CREDIT
                        </span>
                    </div>
                </div>
            </div>

            <!-- Loans -->
            <div
                class="group relative bg-white/80 dark:bg-gray-800/80 backdrop-blur-sm rounded-2xl p-6 shadow-xl hover:shadow-2xl transition-all duration-500 hover:-translate-y-3 border border-gray-200/50 dark:border-gray-700/50 hover:border-orange-300/50 dark:hover:border-orange-600/50 overflow-hidden">
                <!-- Card Glow Effect -->
                <div
                    class="absolute inset-0 bg-gradient-to-br from-orange-500/10 via-transparent to-red-500/10 opacity-0 group-hover:opacity-100 transition-opacity duration-500">
                </div>

                <div class="relative z-10">
                    <div
                        class="flex items-center justify-center w-16 h-16 bg-gradient-to-br from-orange-100 to-orange-200 dark:from-orange-900/50 dark:to-orange-800/50 rounded-2xl mb-6 group-hover:scale-110 group-hover:rotate-6 transition-all duration-300 shadow-lg">
                        <i class="fa-solid fa-hand-holding-dollar text-xl text-orange-600 dark:text-orange-400"></i>
                    </div>
                    <div class="text-center">
                        <div
                            class="text-3xl lg:text-4xl font-bold bg-gradient-to-r from-orange-600 to-red-600 dark:from-orange-400 dark:to-red-400 bg-clip-text text-transparent mb-2">
                            15.49%</div>
                        <div class="text-sm text-gray-500 dark:text-gray-400 mb-3 font-medium">APR*</div>
                        <div class="font-bold text-gray-900 dark:text-white mb-2 text-sm">LOANS</div>
                        <div class="text-xs text-gray-600 dark:text-gray-400 leading-relaxed"><?php echo e(config('app.name')); ?>

                            Standard Loan Rates</div>
                    </div>
                    <div class="mt-4 text-center">
                        <span
                            class="inline-flex items-center px-3 py-1.5 bg-gradient-to-r from-orange-100 to-orange-200 dark:from-orange-900/30 dark:to-orange-800/30 text-orange-700 dark:text-orange-400 rounded-full text-xs font-bold shadow-sm">
                            <i class="fa-solid fa-percentage mr-1"></i>
                            MORTGAGE
                        </span>
                    </div>
                </div>
            </div>
        </div>

        <!-- Disclaimer -->
        <div class="text-center mt-8 lg:mt-12">
            <div
                class="inline-flex items-center px-4 py-2 bg-white/80 dark:bg-gray-800/80 backdrop-blur-sm rounded-full shadow-lg border border-gray-200/50 dark:border-gray-700/50">
                <i class="fa-solid fa-info-circle text-primary-600 dark:text-primary-400 mr-2"></i>
                <p class="text-sm text-gray-600 dark:text-gray-300 font-medium">
                    *Annual Percentage Yield. Rates subject to change. Terms and conditions apply.
                </p>
            </div>
        </div>
    </div>
</section>
<?php /**PATH C:\xampp\htdocs\projects\online-banking-v7.0\resources\views/frontend/layouts/partials/rates.blade.php ENDPATH**/ ?>