<!-- Feature Section 1 -->
<section
    class="relative py-16 lg:py-20 bg-gradient-to-br from-white via-gray-50 to-green-50 dark:from-gray-900 dark:via-gray-800 dark:to-green-900/20 overflow-hidden">
    <!-- Background Elements -->
    <div class="absolute inset-0 opacity-20">
        <div
            class="absolute top-10 right-10 w-64 h-64 bg-green-200 dark:bg-green-800 rounded-full blur-3xl animate-pulse">
        </div>
        <div
            class="absolute bottom-10 left-10 w-80 h-80 bg-primary-200 dark:bg-primary-800 rounded-full blur-3xl animate-pulse delay-500">
        </div>
    </div>

    <div class="relative z-10 max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="grid lg:grid-cols-2 gap-12 lg:gap-16 items-center">
            <!-- Image -->
            <div class="order-2 lg:order-1">
                <div class="relative group">
                    <div
                        class="absolute -inset-4 bg-gradient-to-r from-green-500/20 to-primary-500/20 rounded-3xl blur-lg opacity-75 group-hover:opacity-100 transition-opacity duration-500">
                    </div>
                    <div
                        class="relative rounded-3xl aspect-[4/3] overflow-hidden shadow-2xl group-hover:shadow-3xl transition-all duration-500 border border-white/20 dark:border-gray-700/50">
                        <img src="/frontend/images/home/feature.jpg" alt="Happy family with financial security"
                            class="w-full h-full object-cover group-hover:scale-105 transition-transform duration-700">
                        <!-- Overlay -->
                        <div
                            class="absolute inset-0 bg-gradient-to-t from-black/20 via-transparent to-transparent opacity-0 group-hover:opacity-100 transition-opacity duration-500">
                        </div>
                    </div>
                </div>
            </div>

            <!-- Content -->
            <div class="order-1 lg:order-2 space-y-6">
                <div
                    class="inline-flex items-center px-4 py-2 bg-gradient-to-r from-green-100 to-green-200 dark:from-green-900/50 dark:to-green-800/50 text-green-700 dark:text-green-300 rounded-full text-sm font-bold mb-6 shadow-lg backdrop-blur-sm border border-green-200/50 dark:border-green-700/50">
                    <i class="fa-solid fa-dollar-sign mr-2 animate-pulse"></i>
                    Get $200* With a Checking Account Built for You
                </div>
                <h2
                    class="text-3xl sm:text-4xl lg:text-5xl font-bold bg-gradient-to-r from-gray-900 via-green-700 to-gray-900 dark:from-white dark:via-green-300 dark:to-white bg-clip-text text-transparent leading-tight">
                    Start Building Your Financial Strength
                </h2>
                <p class="text-lg text-gray-600 dark:text-gray-300 leading-relaxed">
                    For a limited time, get a $200 when you open any new account, and what helps you reach your
                    financial goals. You can open a new account online or in person at any of our locations.
                </p>

                <!-- Benefits List -->
                <div class="space-y-3">
                    <div class="flex items-center space-x-3">
                        <div
                            class="flex-shrink-0 w-6 h-6 bg-green-100 dark:bg-green-900/50 rounded-full flex items-center justify-center">
                            <i class="fa-solid fa-check text-green-600 dark:text-green-400 text-sm"></i>
                        </div>
                        <span class="text-gray-700 dark:text-gray-300 font-medium">No minimum balance
                            required</span>
                    </div>
                    <div class="flex items-center space-x-3">
                        <div
                            class="flex-shrink-0 w-6 h-6 bg-green-100 dark:bg-green-900/50 rounded-full flex items-center justify-center">
                            <i class="fa-solid fa-check text-green-600 dark:text-green-400 text-sm"></i>
                        </div>
                        <span class="text-gray-700 dark:text-gray-300 font-medium">Free online and mobile
                            banking</span>
                    </div>
                    <div class="flex items-center space-x-3">
                        <div
                            class="flex-shrink-0 w-6 h-6 bg-green-100 dark:bg-green-900/50 rounded-full flex items-center justify-center">
                            <i class="fa-solid fa-check text-green-600 dark:text-green-400 text-sm"></i>
                        </div>
                        <span class="text-gray-700 dark:text-gray-300 font-medium">24/7 customer support</span>
                    </div>
                </div>

                <a href="<?php echo e(route('register')); ?>"
                    class="inline-flex items-center px-8 py-4 bg-gradient-to-r from-primary-600 to-primary-700 hover:from-primary-700 hover:to-primary-800 text-white font-bold rounded-2xl transition-all duration-300 shadow-2xl hover:shadow-primary-500/25 hover:-translate-y-1 hover:scale-105 group">
                    <i class="fa-solid fa-arrow-right mr-3 group-hover:translate-x-1 transition-transform"></i>
                    Open Account Now
                </a>
            </div>
        </div>
    </div>
</section>
<?php /**PATH C:\xampp\htdocs\projects\online-banking-v7.0\resources\views/frontend/sections/home/feature.blade.php ENDPATH**/ ?>