<!-- Available Grants Section -->
<section class="py-16 bg-white dark:bg-gray-900">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="text-center mb-12">
            <h2 class="text-3xl lg:text-4xl font-bold text-gray-900 dark:text-white mb-4">
                Available Grant Programs
            </h2>
            <p class="text-lg text-gray-600 dark:text-gray-300 max-w-2xl mx-auto">
                Explore our comprehensive grant programs designed to support various financial needs
            </p>
        </div>

        <div class="grid md:grid-cols-2 lg:grid-cols-3 gap-8">
            <!-- Small Business Grant -->
            <div
                class="bg-white dark:bg-gray-800 rounded-2xl p-8 shadow-xl border border-gray-200 dark:border-gray-700 hover:shadow-2xl transition-all duration-300">
                <div class="w-16 h-16 bg-blue-100 dark:bg-blue-900/30 rounded-2xl flex items-center justify-center mb-6">
                    <i class="fa-solid fa-store text-2xl text-blue-600 dark:text-blue-400"></i>
                </div>
                <h3 class="text-xl font-bold text-gray-900 dark:text-white mb-3">Small Business Grant</h3>
                <p class="text-gray-600 dark:text-gray-300 mb-4">
                    Up to $50,000 in funding for small business startups and expansion projects.
                </p>
                <ul class="space-y-2 text-sm text-gray-600 dark:text-gray-300 mb-6">
                    <li class="flex items-center"><i class="fa-solid fa-check text-green-500 mr-2"></i>No collateral
                        required</li>
                    <li class="flex items-center"><i class="fa-solid fa-check text-green-500 mr-2"></i>Flexible
                        repayment terms</li>
                    <li class="flex items-center"><i class="fa-solid fa-check text-green-500 mr-2"></i>Business
                        mentorship included</li>
                </ul>
                <a href="#apply"
                    class="inline-flex items-center text-blue-600 dark:text-blue-400 font-semibold hover:text-blue-700 dark:hover:text-blue-300 transition-colors">
                    Learn More <i class="fa-solid fa-arrow-right ml-2"></i>
                </a>
            </div>

            <!-- Education Grant -->
            <div
                class="bg-white dark:bg-gray-800 rounded-2xl p-8 shadow-xl border border-gray-200 dark:border-gray-700 hover:shadow-2xl transition-all duration-300">
                <div
                    class="w-16 h-16 bg-purple-100 dark:bg-purple-900/30 rounded-2xl flex items-center justify-center mb-6">
                    <i class="fa-solid fa-graduation-cap text-2xl text-purple-600 dark:text-purple-400"></i>
                </div>
                <h3 class="text-xl font-bold text-gray-900 dark:text-white mb-3">Education Grant</h3>
                <p class="text-gray-600 dark:text-gray-300 mb-4">
                    Financial assistance for higher education, vocational training, and skill development.
                </p>
                <ul class="space-y-2 text-sm text-gray-600 dark:text-gray-300 mb-6">
                    <li class="flex items-center"><i class="fa-solid fa-check text-green-500 mr-2"></i>Up to $25,000 per
                        year</li>
                    <li class="flex items-center"><i class="fa-solid fa-check text-green-500 mr-2"></i>Merit-based
                        selection</li>
                    <li class="flex items-center"><i class="fa-solid fa-check text-green-500 mr-2"></i>Career guidance
                        support</li>
                </ul>
                <a href="#apply"
                    class="inline-flex items-center text-purple-600 dark:text-purple-400 font-semibold hover:text-purple-700 dark:hover:text-purple-300 transition-colors">
                    Learn More <i class="fa-solid fa-arrow-right ml-2"></i>
                </a>
            </div>

            <!-- Home Ownership Grant -->
            <div
                class="bg-white dark:bg-gray-800 rounded-2xl p-8 shadow-xl border border-gray-200 dark:border-gray-700 hover:shadow-2xl transition-all duration-300">
                <div
                    class="w-16 h-16 bg-green-100 dark:bg-green-900/30 rounded-2xl flex items-center justify-center mb-6">
                    <i class="fa-solid fa-home text-2xl text-green-600 dark:text-green-400"></i>
                </div>
                <h3 class="text-xl font-bold text-gray-900 dark:text-white mb-3">Home Ownership Grant</h3>
                <p class="text-gray-600 dark:text-gray-300 mb-4">
                    Down payment assistance and closing cost support for first-time homebuyers.
                </p>
                <ul class="space-y-2 text-sm text-gray-600 dark:text-gray-300 mb-6">
                    <li class="flex items-center"><i class="fa-solid fa-check text-green-500 mr-2"></i>Up to $15,000
                        assistance</li>
                    <li class="flex items-center"><i class="fa-solid fa-check text-green-500 mr-2"></i>First-time buyer
                        priority</li>
                    <li class="flex items-center"><i class="fa-solid fa-check text-green-500 mr-2"></i>Homebuyer
                        education</li>
                </ul>
                <a href="#apply"
                    class="inline-flex items-center text-green-600 dark:text-green-400 font-semibold hover:text-green-700 dark:hover:text-green-300 transition-colors">
                    Learn More <i class="fa-solid fa-arrow-right ml-2"></i>
                </a>
            </div>

            <!-- Emergency Relief Grant -->
            <div
                class="bg-white dark:bg-gray-800 rounded-2xl p-8 shadow-xl border border-gray-200 dark:border-gray-700 hover:shadow-2xl transition-all duration-300">
                <div class="w-16 h-16 bg-red-100 dark:bg-red-900/30 rounded-2xl flex items-center justify-center mb-6">
                    <i class="fa-solid fa-heart text-2xl text-red-600 dark:text-red-400"></i>
                </div>
                <h3 class="text-xl font-bold text-gray-900 dark:text-white mb-3">Emergency Relief Grant</h3>
                <p class="text-gray-600 dark:text-gray-300 mb-4">
                    Immediate financial assistance for unexpected emergencies and hardships.
                </p>
                <ul class="space-y-2 text-sm text-gray-600 dark:text-gray-300 mb-6">
                    <li class="flex items-center"><i class="fa-solid fa-check text-green-500 mr-2"></i>Quick approval
                        process</li>
                    <li class="flex items-center"><i class="fa-solid fa-check text-green-500 mr-2"></i>Up to $10,000
                        immediate</li>
                    <li class="flex items-center"><i class="fa-solid fa-check text-green-500 mr-2"></i>24/7 application
                        support</li>
                </ul>
                <a href="#apply"
                    class="inline-flex items-center text-red-600 dark:text-red-400 font-semibold hover:text-red-700 dark:hover:text-red-300 transition-colors">
                    Learn More <i class="fa-solid fa-arrow-right ml-2"></i>
                </a>
            </div>

            <!-- Community Development Grant -->
            <div
                class="bg-white dark:bg-gray-800 rounded-2xl p-8 shadow-xl border border-gray-200 dark:border-gray-700 hover:shadow-2xl transition-all duration-300">
                <div
                    class="w-16 h-16 bg-orange-100 dark:bg-orange-900/30 rounded-2xl flex items-center justify-center mb-6">
                    <i class="fa-solid fa-users text-2xl text-orange-600 dark:text-orange-400"></i>
                </div>
                <h3 class="text-xl font-bold text-gray-900 dark:text-white mb-3">Community Development</h3>
                <p class="text-gray-600 dark:text-gray-300 mb-4">
                    Support for community projects, non-profits, and local development initiatives.
                </p>
                <ul class="space-y-2 text-sm text-gray-600 dark:text-gray-300 mb-6">
                    <li class="flex items-center"><i class="fa-solid fa-check text-green-500 mr-2"></i>Up to $100,000
                        funding</li>
                    <li class="flex items-center"><i class="fa-solid fa-check text-green-500 mr-2"></i>Community impact
                        focus</li>
                    <li class="flex items-center"><i class="fa-solid fa-check text-green-500 mr-2"></i>Ongoing project
                        support</li>
                </ul>
                <a href="#apply"
                    class="inline-flex items-center text-orange-600 dark:text-orange-400 font-semibold hover:text-orange-700 dark:hover:text-orange-300 transition-colors">
                    Learn More <i class="fa-solid fa-arrow-right ml-2"></i>
                </a>
            </div>

            <!-- Healthcare Grant -->
            <div
                class="bg-white dark:bg-gray-800 rounded-2xl p-8 shadow-xl border border-gray-200 dark:border-gray-700 hover:shadow-2xl transition-all duration-300">
                <div
                    class="w-16 h-16 bg-teal-100 dark:bg-teal-900/30 rounded-2xl flex items-center justify-center mb-6">
                    <i class="fa-solid fa-stethoscope text-2xl text-teal-600 dark:text-teal-400"></i>
                </div>
                <h3 class="text-xl font-bold text-gray-900 dark:text-white mb-3">Healthcare Grant</h3>
                <p class="text-gray-600 dark:text-gray-300 mb-4">
                    Medical expense assistance and healthcare accessibility support programs.
                </p>
                <ul class="space-y-2 text-sm text-gray-600 dark:text-gray-300 mb-6">
                    <li class="flex items-center"><i class="fa-solid fa-check text-green-500 mr-2"></i>Medical bill
                        assistance</li>
                    <li class="flex items-center"><i class="fa-solid fa-check text-green-500 mr-2"></i>Prescription
                        drug support</li>
                    <li class="flex items-center"><i class="fa-solid fa-check text-green-500 mr-2"></i>Health
                        insurance help</li>
                </ul>
                <a href="#apply"
                    class="inline-flex items-center text-teal-600 dark:text-teal-400 font-semibold hover:text-teal-700 dark:hover:text-teal-300 transition-colors">
                    Learn More <i class="fa-solid fa-arrow-right ml-2"></i>
                </a>
            </div>
        </div>
    </div>
</section>
<?php /**PATH C:\xampp\htdocs\projects\online-banking-v7.0\resources\views/frontend/sections/services/grant/available_grant.blade.php ENDPATH**/ ?>