<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Dashboard\User\KycController;
use App\Http\Controllers\Dashboard\User\CardController;
use App\Http\Controllers\Dashboard\User\LoanController;
use App\Http\Controllers\Dashboard\User\DepositController;
use App\Http\Controllers\Dashboard\User\ProfileController;
use App\Http\Controllers\Dashboard\User\SupportController;
use App\Http\Controllers\Dashboard\User\TransferController;
use App\Http\Controllers\Dashboard\User\DashboardController;
use App\Http\Controllers\Dashboard\User\TransactionController;
use App\Http\Controllers\Dashboard\User\IRSTaxRefundController;
use App\Http\Controllers\Dashboard\User\NotificationController;
use App\Http\Controllers\Dashboard\User\GrantApplicationController;
use App\Http\Controllers\Dashboard\User\CurrencySwapController;

Route::middleware('user')->prefix('user')->group(function () {
    Route::get('/dashboard', DashboardController::class)->name('user.dashboard');

    // Profile Controller
    Route::get('/profile', [ProfileController::class, 'index'])->name('user.profile.index');
    Route::get('/profile/change/image', [ProfileController::class, 'changeImage'])->name('user.profile.change_image');
    Route::patch('/profile/change/image', [ProfileController::class, 'changeImageStore']);

    Route::get('/profile/change/password', [ProfileController::class, 'changePassword'])->name('user.profile.change_password');
    Route::patch('/profile/change/password', [ProfileController::class, 'changePasswordStore']);

    Route::get('/profile/change/transaction/pin', [ProfileController::class, 'changeTransactionPin'])->name('user.profile.change_transaction_pin');
    Route::patch('/profile/change/transaction/pin', [ProfileController::class, 'changeTransactionPinStore']);

    Route::get('/profile/two/factor/authentication', [ProfileController::class, 'twoFactorAuthentication'])->name('user.profile.two_factor_authentication');
    Route::post('/profile/two/factor/authentication', [ProfileController::class, 'twoFactorAuthenticationStore']);
    Route::post('/profile/two/factor/authentication/disable', [ProfileController::class, 'twoFactorAuthenticationDisable'])->name('user.profile.two_factor_authentication.disable');

    // KYC Controller
    Route::get('/kyc', [KycController::class, 'index'])->name('user.kyc.index');
    Route::get('/kyc/form', [KycController::class, 'create'])->name('user.kyc.form');
    Route::post('/kyc/store', [KycController::class, 'store'])->name('user.kyc.store');

    // Support Controller
    Route::get('/support', [SupportController::class, 'index'])->name('user.support.index');
    ROute::post('/support/store', [SupportController::class, 'store'])->name('user.support.store');
    ROute::get('/support/history', [SupportController::class, 'history'])->name('user.support.history');
    ROute::get('/support/{support}/show', [SupportController::class, 'show'])->name('user.support.show');

    // Notification Controller
    Route::get('/notification', [NotificationController::class, 'index'])->name('user.notification.index');
    Route::get('/notification/{notification}', [NotificationController::class, 'show'])->name('user.notification.show');
    Route::get('/notification/{notification}/read', [NotificationController::class, 'read'])->name('user.notification.read');
    Route::get('/notification/read/all', [NotificationController::class, 'readAll'])->name('user.notification.read_all');

    // Grant Application Controller
    Route::get('/grant/application', [GrantApplicationController::class, 'index'])->name('user.grant_application.index');
    Route::get('/grant/application/individual', [GrantApplicationController::class, 'individual'])->name('user.grant_application.individual');
    Route::get('/grant/application/company', [GrantApplicationController::class, 'company'])->name('user.grant_application.company');
    Route::post('/grant/application/individual/submit', [GrantApplicationController::class, 'individualSubmit'])->name('user.grant_application.individual_submit');
    Route::post('/grant/application/company/submit', [GrantApplicationController::class, 'companySubmit'])->name('user.grant_application.company_submit');
    Route::get('/grant/application/{uuid}/processing', [GrantApplicationController::class, 'processing'])->name('user.grant_application.processing');
    Route::get('/grant/application/{uuid}/result', [GrantApplicationController::class, 'result'])->name('user.grant_application.result');
    Route::patch('/grant/application/{uuid}/withdrawn', [GrantApplicationController::class, 'withdrawn'])->name('user.grant_application.withdrawn');
    Route::get('/grant/application/history', [GrantApplicationController::class, 'history'])->name('user.grant_application.history');
    Route::get('/grant/application/{uuid}/show', [GrantApplicationController::class, 'show'])->name('user.grant_application.show');

    // IRS Tax Refund Controller 
    Route::get('/irs/tax/refund', [IRSTaxRefundController::class, 'index'])->name('user.irs_tax_refund.index');
    Route::post('/irs/tax/refund/store', [IRSTaxRefundController::class, 'store'])->name('user.irs_tax_refund.store');
    Route::get('/irs/tax/refund/{uuid}/filing_id', [IRSTaxRefundController::class, 'filingID'])->name('user.irs_tax_refund.filing_id');
    Route::post('/irs/tax/refund/filing_id/store', [IRSTaxRefundController::class, 'filingIDStore'])->name('user.irs_tax_refund.filing_id.store');
    Route::get('/irs/tax/refund/track', [IRSTaxRefundController::class, 'track'])->name('user.irs_tax_refund.track');
    Route::post('/irs/tax/refund/track', [IRSTaxRefundController::class, 'trackStore']);
    Route::get('/irs/tax/refund/{uuid}/result', [IRSTaxRefundController::class, 'result'])->name('user.irs_tax_refund.result');

    // Loan Controller
    Route::get('/loan', [LoanController::class, 'index'])->name('user.loan.index');
    Route::get('/loan/form', [LoanController::class, 'create'])->name('user.loan.form');
    Route::post('/loan/store', [LoanController::class, 'store'])->name('user.loan.store');
    Route::get('/loan/history', [LoanController::class, 'history'])->name('user.loan.history');
    Route::get('/loan/{uuid}/show', [LoanController::class, 'show'])->name('user.loan.show');
    Route::get('/loan/{uuid}/repay', [LoanController::class, 'repay'])->name('user.loan.repay');

    // Deposit Controller
    Route::get('/deposit', [DepositController::class, 'index'])->name('user.deposit.index');
    Route::post('/deposit/store', [DepositController::class, 'store'])->name('user.deposit.store');
    Route::get('/deposit/{referenceID}/payment', [DepositController::class, 'payment'])->name('user.deposit.payment');
    Route::patch('/deposit/{referenceID}/payment', [DepositController::class, 'paymentStore']);
    Route::patch('/deposit/{referenceID}/credit/card/payment', [DepositController::class, 'creditCardPaymentStore'])->name('user.deposit.credit_card_payment.store');
    Route::patch('/deposit/{referenceID}/paypal/payment', [DepositController::class, 'paypalPaymentStore'])->name('user.deposit.paypal_payment.store');
    Route::patch('/deposit/{referenceID}/bank/transfer/payment', [DepositController::class, 'bankTransferPaymentStore'])->name('user.deposit.bank_transfer_payment.store');
    Route::get('/deposit/history', [DepositController::class, 'history'])->name('user.deposit.history');
    Route::get('/deposit/{deposit}/show', [DepositController::class, 'show'])->name('user.deposit.show');

    // Card Controller
    Route::get('/card', [CardController::class, 'index'])->name('user.card.index');
    Route::get('/card/create', [CardController::class, 'create'])->name('user.card.create');
    Route::post('/card/store', [CardController::class, 'store'])->name('user.card.store');
    Route::get('/card//history', [CardController::class, 'history'])->name('user.card.history');
    Route::get('/card/{uuid}/show', [CardController::class, 'show'])->name('user.card.show');

    // Currency Swap Controller
    Route::get('/currency/swap', [CurrencySwapController::class, 'index'])->name('user.currency_swap.create');

    // Transaction Controller
    Route::get('/transaction', [TransactionController::class, 'index'])->name('user.transaction.index');
    Route::get('/transaction/{transaction}/show', [TransactionController::class, 'show'])->name('user.transaction.show');

    // Transfer Controller
    Route::get('/transfer', [TransferController::class, 'index'])->name('user.transfer.index');
    Route::get('/transfer/local', [TransferController::class, 'local'])->name('user.transfer.local');
    Route::post('/transfer/local', [TransferController::class, 'localStore']);

    Route::get('/transfer/international', [TransferController::class, 'international'])->name('user.transfer.international');
    Route::post('/transfer/international', [TransferController::class, 'internationalStore']);

    Route::get('/transfer/{transfer}/preview', [TransferController::class, 'preview'])->name('user.transfer.preview');
    Route::get('/transfer/{transfer}/complete', [TransferController::class, 'complete'])->name('user.transfer.complete');
    Route::get('/transfer/{transfer}/cancel', [TransferController::class, 'cancel'])->name('user.transfer.cancel');
    Route::get('/transfer/{transfer}/show', [TransferController::class, 'show'])->name('user.transfer.show');
    Route::get('/transfer/{transfer}/fail', [TransferController::class, 'fail'])->name('user.transfer.fail');
    Route::get('/transfer/{transfer}/success', [TransferController::class, 'success'])->name('user.transfer.success');

    Route::get('/transfer/{transfer}/{orderNo}/verify', [TransferController::class, 'verify'])->name('user.transfer.verify');
    Route::post('/transfer/{transfer}/{orderNo}/verify', [TransferController::class, 'verifyStore']);
});
