 <!-- Loan Types Section -->
 <section class="py-16 bg-white dark:bg-gray-900">
     <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
         <div class="text-center mb-12">
             <h2 class="text-3xl lg:text-4xl font-bold text-gray-900 dark:text-white mb-4">
                 Loan Options
             </h2>
             <p class="text-lg text-gray-600 dark:text-gray-300 max-w-2xl mx-auto">
                 Find the perfect loan solution for your personal or business needs
             </p>
         </div>

         <div class="grid md:grid-cols-2 lg:grid-cols-3 gap-8">
             <!-- Home Loans -->
             <div
                 class="bg-white dark:bg-gray-800 rounded-2xl p-8 shadow-xl border border-gray-200 dark:border-gray-700 hover:shadow-2xl transition-all duration-300">
                 <div
                     class="w-16 h-16 bg-blue-100 dark:bg-blue-900/30 rounded-2xl flex items-center justify-center mb-6">
                     <i class="fa-solid fa-home text-2xl text-blue-600 dark:text-blue-400"></i>
                 </div>
                 <h3 class="text-xl font-bold text-gray-900 dark:text-white mb-3">Home Loans</h3>
                 <p class="text-gray-600 dark:text-gray-300 mb-4">
                     Competitive mortgage rates for first-time buyers and refinancing.
                 </p>
                 <div class="space-y-2 text-sm text-gray-600 dark:text-gray-300 mb-6">
                     <div class="flex justify-between">
                         <span>Interest Rate:</span>
                         <span class="font-semibold text-blue-600 dark:text-blue-400">From 3.25% APR</span>
                     </div>
                     <div class="flex justify-between">
                         <span>Loan Amount:</span>
                         <span class="font-semibold">Up to $1M</span>
                     </div>
                     <div class="flex justify-between">
                         <span>Term:</span>
                         <span class="font-semibold">15-30 years</span>
                     </div>
                 </div>
                 <a href="#apply"
                     class="inline-flex items-center text-blue-600 dark:text-blue-400 font-semibold hover:text-blue-700 dark:hover:text-blue-300 transition-colors">
                     Apply Now <i class="fa-solid fa-arrow-right ml-2"></i>
                 </a>
             </div>

             <!-- Auto Loans -->
             <div
                 class="bg-white dark:bg-gray-800 rounded-2xl p-8 shadow-xl border border-gray-200 dark:border-gray-700 hover:shadow-2xl transition-all duration-300">
                 <div
                     class="w-16 h-16 bg-green-100 dark:bg-green-900/30 rounded-2xl flex items-center justify-center mb-6">
                     <i class="fa-solid fa-car text-2xl text-green-600 dark:text-green-400"></i>
                 </div>
                 <h3 class="text-xl font-bold text-gray-900 dark:text-white mb-3">Auto Loans</h3>
                 <p class="text-gray-600 dark:text-gray-300 mb-4">
                     Finance your dream car with our competitive auto loan rates.
                 </p>
                 <div class="space-y-2 text-sm text-gray-600 dark:text-gray-300 mb-6">
                     <div class="flex justify-between">
                         <span>Interest Rate:</span>
                         <span class="font-semibold text-green-600 dark:text-green-400">From 2.99% APR</span>
                     </div>
                     <div class="flex justify-between">
                         <span>Loan Amount:</span>
                         <span class="font-semibold">Up to $100K</span>
                     </div>
                     <div class="flex justify-between">
                         <span>Term:</span>
                         <span class="font-semibold">3-7 years</span>
                     </div>
                 </div>
                 <a href="#apply"
                     class="inline-flex items-center text-green-600 dark:text-green-400 font-semibold hover:text-green-700 dark:hover:text-green-300 transition-colors">
                     Apply Now <i class="fa-solid fa-arrow-right ml-2"></i>
                 </a>
             </div>

             <!-- Personal Loans -->
             <div
                 class="bg-white dark:bg-gray-800 rounded-2xl p-8 shadow-xl border border-gray-200 dark:border-gray-700 hover:shadow-2xl transition-all duration-300">
                 <div
                     class="w-16 h-16 bg-purple-100 dark:bg-purple-900/30 rounded-2xl flex items-center justify-center mb-6">
                     <i class="fa-solid fa-user text-2xl text-purple-600 dark:text-purple-400"></i>
                 </div>
                 <h3 class="text-xl font-bold text-gray-900 dark:text-white mb-3">Personal Loans</h3>
                 <p class="text-gray-600 dark:text-gray-300 mb-4">
                     Flexible personal loans for any purpose with quick approval.
                 </p>
                 <div class="space-y-2 text-sm text-gray-600 dark:text-gray-300 mb-6">
                     <div class="flex justify-between">
                         <span>Interest Rate:</span>
                         <span class="font-semibold text-purple-600 dark:text-purple-400">From 5.99% APR</span>
                     </div>
                     <div class="flex justify-between">
                         <span>Loan Amount:</span>
                         <span class="font-semibold">Up to $50K</span>
                     </div>
                     <div class="flex justify-between">
                         <span>Term:</span>
                         <span class="font-semibold">2-7 years</span>
                     </div>
                 </div>
                 <a href="#apply"
                     class="inline-flex items-center text-purple-600 dark:text-purple-400 font-semibold hover:text-purple-700 dark:hover:text-purple-300 transition-colors">
                     Apply Now <i class="fa-solid fa-arrow-right ml-2"></i>
                 </a>
             </div>

             <!-- Business Loans -->
             <div
                 class="bg-white dark:bg-gray-800 rounded-2xl p-8 shadow-xl border border-gray-200 dark:border-gray-700 hover:shadow-2xl transition-all duration-300">
                 <div
                     class="w-16 h-16 bg-orange-100 dark:bg-orange-900/30 rounded-2xl flex items-center justify-center mb-6">
                     <i class="fa-solid fa-briefcase text-2xl text-orange-600 dark:text-orange-400"></i>
                 </div>
                 <h3 class="text-xl font-bold text-gray-900 dark:text-white mb-3">Business Loans</h3>
                 <p class="text-gray-600 dark:text-gray-300 mb-4">
                     Grow your business with our flexible commercial lending solutions.
                 </p>
                 <div class="space-y-2 text-sm text-gray-600 dark:text-gray-300 mb-6">
                     <div class="flex justify-between">
                         <span>Interest Rate:</span>
                         <span class="font-semibold text-orange-600 dark:text-orange-400">From 4.25% APR</span>
                     </div>
                     <div class="flex justify-between">
                         <span>Loan Amount:</span>
                         <span class="font-semibold">Up to $5M</span>
                     </div>
                     <div class="flex justify-between">
                         <span>Term:</span>
                         <span class="font-semibold">1-25 years</span>
                     </div>
                 </div>
                 <a href="#apply"
                     class="inline-flex items-center text-orange-600 dark:text-orange-400 font-semibold hover:text-orange-700 dark:hover:text-orange-300 transition-colors">
                     Apply Now <i class="fa-solid fa-arrow-right ml-2"></i>
                 </a>
             </div>

             <!-- Student Loans -->
             <div
                 class="bg-white dark:bg-gray-800 rounded-2xl p-8 shadow-xl border border-gray-200 dark:border-gray-700 hover:shadow-2xl transition-all duration-300">
                 <div
                     class="w-16 h-16 bg-teal-100 dark:bg-teal-900/30 rounded-2xl flex items-center justify-center mb-6">
                     <i class="fa-solid fa-graduation-cap text-2xl text-teal-600 dark:text-teal-400"></i>
                 </div>
                 <h3 class="text-xl font-bold text-gray-900 dark:text-white mb-3">Student Loans</h3>
                 <p class="text-gray-600 dark:text-gray-300 mb-4">
                     Invest in your education with competitive student loan rates.
                 </p>
                 <div class="space-y-2 text-sm text-gray-600 dark:text-gray-300 mb-6">
                     <div class="flex justify-between">
                         <span>Interest Rate:</span>
                         <span class="font-semibold text-teal-600 dark:text-teal-400">From 3.75% APR</span>
                     </div>
                     <div class="flex justify-between">
                         <span>Loan Amount:</span>
                         <span class="font-semibold">Up to $200K</span>
                     </div>
                     <div class="flex justify-between">
                         <span>Term:</span>
                         <span class="font-semibold">5-20 years</span>
                     </div>
                 </div>
                 <a href="#apply"
                     class="inline-flex items-center text-teal-600 dark:text-teal-400 font-semibold hover:text-teal-700 dark:hover:text-teal-300 transition-colors">
                     Apply Now <i class="fa-solid fa-arrow-right ml-2"></i>
                 </a>
             </div>

             <!-- Home Equity -->
             <div
                 class="bg-white dark:bg-gray-800 rounded-2xl p-8 shadow-xl border border-gray-200 dark:border-gray-700 hover:shadow-2xl transition-all duration-300">
                 <div class="w-16 h-16 bg-red-100 dark:bg-red-900/30 rounded-2xl flex items-center justify-center mb-6">
                     <i class="fa-solid fa-house-circle-check text-2xl text-red-600 dark:text-red-400"></i>
                 </div>
                 <h3 class="text-xl font-bold text-gray-900 dark:text-white mb-3">Home Equity</h3>
                 <p class="text-gray-600 dark:text-gray-300 mb-4">
                     Tap into your home's equity for major expenses or investments.
                 </p>
                 <div class="space-y-2 text-sm text-gray-600 dark:text-gray-300 mb-6">
                     <div class="flex justify-between">
                         <span>Interest Rate:</span>
                         <span class="font-semibold text-red-600 dark:text-red-400">From 4.50% APR</span>
                     </div>
                     <div class="flex justify-between">
                         <span>Loan Amount:</span>
                         <span class="font-semibold">Up to $500K</span>
                     </div>
                     <div class="flex justify-between">
                         <span>Term:</span>
                         <span class="font-semibold">5-30 years</span>
                     </div>
                 </div>
                 <a href="#apply"
                     class="inline-flex items-center text-red-600 dark:text-red-400 font-semibold hover:text-red-700 dark:hover:text-red-300 transition-colors">
                     Apply Now <i class="fa-solid fa-arrow-right ml-2"></i>
                 </a>
             </div>
         </div>
     </div>
 </section>
