 <!-- Feature Section 2 -->
 <section
     class="relative py-16 lg:py-20 bg-gradient-to-br from-slate-50 via-primary-50 to-teal-50 dark:from-gray-800 dark:via-primary-900/20 dark:to-teal-900/20 overflow-hidden">
     <!-- Background Elements -->
     <div class="absolute inset-0 opacity-20">
         <div class="absolute top-20 left-20 w-72 h-72 bg-teal-200 dark:bg-teal-800 rounded-full blur-3xl animate-float">
         </div>
         <div
             class="absolute bottom-20 right-20 w-96 h-96 bg-primary-200 dark:bg-primary-800 rounded-full blur-3xl animate-float-delayed">
         </div>
     </div>

     <div class="relative z-10 max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
         <div class="grid lg:grid-cols-2 gap-12 lg:gap-16 items-center">
             <!-- Content -->
             <div class="space-y-6">
                 <div
                     class="inline-flex items-center px-4 py-2 bg-gradient-to-r from-primary-100 to-teal-100 dark:from-primary-900/50 dark:to-teal-900/50 text-primary-700 dark:text-primary-300 rounded-full text-sm font-bold mb-4 shadow-lg backdrop-blur-sm border border-primary-200/50 dark:border-primary-700/50">
                     <i class="fa-solid fa-handshake mr-2 animate-pulse"></i>
                     Member-Focused Banking
                 </div>

                 <h2
                     class="text-3xl sm:text-4xl lg:text-5xl font-bold bg-gradient-to-r from-gray-900 via-primary-700 to-teal-700 dark:from-white dark:via-primary-300 dark:to-teal-300 bg-clip-text text-transparent leading-tight">
                     Building Strength Together
                 </h2>

                 <p class="text-lg text-gray-600 dark:text-gray-300 leading-relaxed">
                     {{ config('app.name') }} is a full-service credit union built on the foundation of
                     providing our members with every step of their financial journey. We're committed to helping
                     our members achieve their financial goals through personalized service and competitive
                     rates.
                 </p>

                 <div class="space-y-4">
                     <div
                         class="group flex items-start space-x-4 p-4 rounded-2xl bg-white/50 dark:bg-gray-800/50 backdrop-blur-sm border border-gray-200/50 dark:border-gray-700/50 hover:bg-white/80 dark:hover:bg-gray-800/80 transition-all duration-300 hover:shadow-lg">
                         <div
                             class="flex-shrink-0 w-10 h-10 bg-gradient-to-br from-primary-100 to-primary-200 dark:from-primary-900/50 dark:to-primary-800/50 rounded-xl flex items-center justify-center group-hover:scale-110 transition-transform duration-300">
                             <i class="fa-solid fa-chart-line text-primary-600 dark:text-primary-400"></i>
                         </div>
                         <div>
                             <h4 class="font-bold text-gray-900 dark:text-white mb-1">Competitive Rates</h4>
                             <p class="text-gray-600 dark:text-gray-300">Better rates on savings, loans, and
                                 credit cards designed to maximize your financial growth.</p>
                         </div>
                     </div>

                     <div
                         class="group flex items-start space-x-4 p-4 rounded-2xl bg-white/50 dark:bg-gray-800/50 backdrop-blur-sm border border-gray-200/50 dark:border-gray-700/50 hover:bg-white/80 dark:hover:bg-gray-800/80 transition-all duration-300 hover:shadow-lg">
                         <div
                             class="flex-shrink-0 w-10 h-10 bg-gradient-to-br from-teal-100 to-teal-200 dark:from-teal-900/50 dark:to-teal-800/50 rounded-xl flex items-center justify-center group-hover:scale-110 transition-transform duration-300">
                             <i class="fa-solid fa-users text-teal-600 dark:text-teal-400"></i>
                         </div>
                         <div>
                             <h4 class="font-bold text-gray-900 dark:text-white mb-1">Member-Focused</h4>
                             <p class="text-gray-600 dark:text-gray-300">We're owned by our members, not
                                 shareholders. Your success is our priority.</p>
                         </div>
                     </div>

                     <div
                         class="group flex items-start space-x-4 p-4 rounded-2xl bg-white/50 dark:bg-gray-800/50 backdrop-blur-sm border border-gray-200/50 dark:border-gray-700/50 hover:bg-white/80 dark:hover:bg-gray-800/80 transition-all duration-300 hover:shadow-lg">
                         <div
                             class="flex-shrink-0 w-10 h-10 bg-gradient-to-br from-purple-100 to-purple-200 dark:from-purple-900/50 dark:to-purple-800/50 rounded-xl flex items-center justify-center group-hover:scale-110 transition-transform duration-300">
                             <i class="fa-solid fa-heart text-purple-600 dark:text-purple-400"></i>
                         </div>
                         <div>
                             <h4 class="font-bold text-gray-900 dark:text-white mb-1">Community Committed</h4>
                             <p class="text-gray-600 dark:text-gray-300">Supporting local communities and causes
                                 that matter to our members.</p>
                         </div>
                     </div>
                 </div>
             </div>

             <!-- Enhanced Image Grid -->
             <div class="grid grid-cols-2 gap-4">
                 <div class="space-y-4">
                     <div
                         class="group relative rounded-2xl aspect-square overflow-hidden shadow-xl hover:shadow-2xl transition-all duration-500">
                         <div
                             class="absolute -inset-1 bg-gradient-to-r from-primary-500/20 to-teal-500/20 rounded-2xl blur opacity-75 group-hover:opacity-100 transition-opacity duration-500">
                         </div>
                         <div class="relative rounded-2xl overflow-hidden">
                             <img src="https://images.unsplash.com/photo-1554224155-6726b3ff858f?ixlib=rb-4.0.3&amp;auto=format&amp;fit=crop&amp;w=400&amp;q=80"
                                 alt="Team collaboration in banking"
                                 class="w-full h-full object-cover group-hover:scale-110 transition-transform duration-700">
                             <div
                                 class="absolute inset-0 bg-gradient-to-t from-black/30 via-transparent to-transparent opacity-0 group-hover:opacity-100 transition-opacity duration-500">
                             </div>
                         </div>
                     </div>
                     <div
                         class="group relative rounded-2xl aspect-[4/3] overflow-hidden shadow-xl hover:shadow-2xl transition-all duration-500">
                         <div
                             class="absolute -inset-1 bg-gradient-to-r from-teal-500/20 to-purple-500/20 rounded-2xl blur opacity-75 group-hover:opacity-100 transition-opacity duration-500">
                         </div>
                         <div class="relative rounded-2xl overflow-hidden">
                             <img src="https://images.unsplash.com/photo-1507003211169-0a1dd7228f2d?ixlib=rb-4.0.3&amp;auto=format&amp;fit=crop&amp;w=400&amp;q=80"
                                 alt="Professional banking consultant"
                                 class="w-full h-full object-cover group-hover:scale-110 transition-transform duration-700">
                             <div
                                 class="absolute inset-0 bg-gradient-to-t from-black/30 via-transparent to-transparent opacity-0 group-hover:opacity-100 transition-opacity duration-500">
                             </div>
                         </div>
                     </div>
                 </div>
                 <div class="space-y-4 pt-8">
                     <div
                         class="group relative rounded-2xl aspect-[4/3] overflow-hidden shadow-xl hover:shadow-2xl transition-all duration-500">
                         <div
                             class="absolute -inset-1 bg-gradient-to-r from-purple-500/20 to-primary-500/20 rounded-2xl blur opacity-75 group-hover:opacity-100 transition-opacity duration-500">
                         </div>
                         <div class="relative rounded-2xl overflow-hidden">
                             <img src="https://images.unsplash.com/photo-1551836022-deb4988cc6c0?ixlib=rb-4.0.3&amp;auto=format&amp;fit=crop&amp;w=400&amp;q=80"
                                 alt="Modern banking technology"
                                 class="w-full h-full object-cover group-hover:scale-110 transition-transform duration-700">
                             <div
                                 class="absolute inset-0 bg-gradient-to-t from-black/30 via-transparent to-transparent opacity-0 group-hover:opacity-100 transition-opacity duration-500">
                             </div>
                         </div>
                     </div>
                     <div
                         class="group relative rounded-2xl aspect-square overflow-hidden shadow-xl hover:shadow-2xl transition-all duration-500">
                         <div
                             class="absolute -inset-1 bg-gradient-to-r from-primary-500/20 to-teal-500/20 rounded-2xl blur opacity-75 group-hover:opacity-100 transition-opacity duration-500">
                         </div>
                         <div class="relative rounded-2xl overflow-hidden">
                             <img src="https://images.unsplash.com/photo-1559526324-4b87b5e36e44?ixlib=rb-4.0.3&amp;auto=format&amp;fit=crop&amp;w=400&amp;q=80"
                                 alt="Community banking support"
                                 class="w-full h-full object-cover group-hover:scale-110 transition-transform duration-700">
                             <div
                                 class="absolute inset-0 bg-gradient-to-t from-black/30 via-transparent to-transparent opacity-0 group-hover:opacity-100 transition-opacity duration-500">
                             </div>
                         </div>
                     </div>
                 </div>
             </div>
         </div>
     </div>
 </section>
