<!-- Mobile App Hero Section -->
<section
    class="relative py-16 lg:py-20 bg-gradient-to-br from-slate-900 via-primary-900 to-gray-900 dark:from-gray-900 dark:via-primary-900 dark:to-black overflow-hidden">
    <div class="absolute inset-0">
        <div class="absolute inset-0 opacity-10">
            <div class="absolute top-0 left-0 w-full h-full"
                style="background-image: radial-gradient(circle at 25% 25%, #ffffff 1px, transparent 1px), radial-gradient(circle at 75% 75%, #ffffff 1px, transparent 1px); background-size: 60px 60px; animation: float 20s ease-in-out infinite;">
            </div>
        </div>
        <div class="absolute top-20 left-20 w-96 h-96 bg-blue-500/20 rounded-full blur-3xl animate-pulse"></div>
        <div
            class="absolute bottom-20 right-20 w-80 h-80 bg-purple-500/20 rounded-full blur-3xl animate-pulse delay-1000">
        </div>
    </div>

    <div class="relative z-10 max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="grid lg:grid-cols-2 gap-12 items-center">
            <div>
                <div
                    class="inline-flex items-center px-4 py-2 bg-white/10 backdrop-blur-sm text-white/90 rounded-full text-sm font-semibold mb-6 border border-white/20">
                    <i class="fa-solid fa-mobile-alt mr-2"></i>
                    Mobile Banking
                </div>
                <h1 class="text-4xl sm:text-5xl lg:text-6xl font-bold text-white mb-6">
                    Banking Made Mobile
                </h1>
                <p class="text-xl text-gray-300 mb-8">
                    Take control of your finances with our award-winning mobile banking app. Available for iOS and
                    Android.
                </p>
                <div class="flex flex-col sm:flex-row gap-4">
                    <a href="#"
                        class="inline-flex items-center px-6 py-3 bg-black text-white rounded-xl hover:bg-gray-800 transition-colors">
                        <i class="fa-brands fa-apple text-2xl mr-3"></i>
                        <div class="text-left">
                            <div class="text-xs">Download on the</div>
                            <div class="font-semibold">App Store</div>
                        </div>
                    </a>
                    <a href="#"
                        class="inline-flex items-center px-6 py-3 bg-black text-white rounded-xl hover:bg-gray-800 transition-colors">
                        <i class="fa-brands fa-google-play text-2xl mr-3"></i>
                        <div class="text-left">
                            <div class="text-xs">Get it on</div>
                            <div class="font-semibold">Google Play</div>
                        </div>
                    </a>
                </div>
            </div>
            <div class="relative">
                <div class="relative z-10">
                    <img src="https://images.unsplash.com/photo-1512941937669-90a1b58e7e9c?ixlib=rb-4.0.3&amp;auto=format&amp;fit=crop&amp;w=600&amp;q=80"
                        alt="Mobile banking app interface" class="w-full max-w-md mx-auto rounded-3xl shadow-2xl">
                </div>
                <div
                    class="absolute inset-0 bg-gradient-to-r from-primary-500/20 to-purple-500/20 rounded-3xl blur-2xl">
                </div>
            </div>
        </div>
    </div>
</section>
