<!-- App Features Section -->
<section class="py-16 bg-white dark:bg-gray-900">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="text-center mb-12">
            <h2 class="text-3xl lg:text-4xl font-bold text-gray-900 dark:text-white mb-4">
                Powerful Features at Your Fingertips
            </h2>
            <p class="text-lg text-gray-600 dark:text-gray-300 max-w-2xl mx-auto">
                Everything you need to manage your finances, all in one convenient mobile app
            </p>
        </div>

        <div class="grid md:grid-cols-2 lg:grid-cols-3 gap-8">
            <!-- Account Management -->
            <div
                class="bg-white dark:bg-gray-800 rounded-2xl p-8 shadow-xl border border-gray-200 dark:border-gray-700 hover:shadow-2xl transition-all duration-300">
                <div class="w-16 h-16 bg-blue-100 dark:bg-blue-900/30 rounded-2xl flex items-center justify-center mb-6">
                    <i class="fa-solid fa-chart-pie text-2xl text-blue-600 dark:text-blue-400"></i>
                </div>
                <h3 class="text-xl font-bold text-gray-900 dark:text-white mb-3">Account Overview</h3>
                <p class="text-gray-600 dark:text-gray-300 mb-4">
                    View all your accounts, balances, and recent transactions in one place.
                </p>
                <ul class="space-y-2 text-sm text-gray-600 dark:text-gray-300">
                    <li class="flex items-center"><i class="fa-solid fa-check text-green-500 mr-2"></i>Real-time balance
                        updates</li>
                    <li class="flex items-center"><i class="fa-solid fa-check text-green-500 mr-2"></i>Transaction
                        history</li>
                    <li class="flex items-center"><i class="fa-solid fa-check text-green-500 mr-2"></i>Account
                        statements</li>
                </ul>
            </div>

            <!-- Money Transfers -->
            <div
                class="bg-white dark:bg-gray-800 rounded-2xl p-8 shadow-xl border border-gray-200 dark:border-gray-700 hover:shadow-2xl transition-all duration-300">
                <div
                    class="w-16 h-16 bg-green-100 dark:bg-green-900/30 rounded-2xl flex items-center justify-center mb-6">
                    <i class="fa-solid fa-money-bill-transfer text-2xl text-green-600 dark:text-green-400"></i>
                </div>
                <h3 class="text-xl font-bold text-gray-900 dark:text-white mb-3">Send Money</h3>
                <p class="text-gray-600 dark:text-gray-300 mb-4">
                    Transfer money instantly to friends, family, or between your accounts.
                </p>
                <ul class="space-y-2 text-sm text-gray-600 dark:text-gray-300">
                    <li class="flex items-center"><i class="fa-solid fa-check text-green-500 mr-2"></i>Instant transfers
                    </li>
                    <li class="flex items-center"><i class="fa-solid fa-check text-green-500 mr-2"></i>Zelle integration
                    </li>
                    <li class="flex items-center"><i class="fa-solid fa-check text-green-500 mr-2"></i>International
                        wire transfers</li>
                </ul>
            </div>

            <!-- Bill Pay -->
            <div
                class="bg-white dark:bg-gray-800 rounded-2xl p-8 shadow-xl border border-gray-200 dark:border-gray-700 hover:shadow-2xl transition-all duration-300">
                <div
                    class="w-16 h-16 bg-purple-100 dark:bg-purple-900/30 rounded-2xl flex items-center justify-center mb-6">
                    <i class="fa-solid fa-file-invoice-dollar text-2xl text-purple-600 dark:text-purple-400"></i>
                </div>
                <h3 class="text-xl font-bold text-gray-900 dark:text-white mb-3">Bill Pay</h3>
                <p class="text-gray-600 dark:text-gray-300 mb-4">
                    Schedule and pay all your bills from one convenient location.
                </p>
                <ul class="space-y-2 text-sm text-gray-600 dark:text-gray-300">
                    <li class="flex items-center"><i class="fa-solid fa-check text-green-500 mr-2"></i>Automatic
                        payments</li>
                    <li class="flex items-center"><i class="fa-solid fa-check text-green-500 mr-2"></i>Payment reminders
                    </li>
                    <li class="flex items-center"><i class="fa-solid fa-check text-green-500 mr-2"></i>Payee management
                    </li>
                </ul>
            </div>

            <!-- Mobile Deposit -->
            <div
                class="bg-white dark:bg-gray-800 rounded-2xl p-8 shadow-xl border border-gray-200 dark:border-gray-700 hover:shadow-2xl transition-all duration-300">
                <div
                    class="w-16 h-16 bg-orange-100 dark:bg-orange-900/30 rounded-2xl flex items-center justify-center mb-6">
                    <i class="fa-solid fa-camera text-2xl text-orange-600 dark:text-orange-400"></i>
                </div>
                <h3 class="text-xl font-bold text-gray-900 dark:text-white mb-3">Mobile Deposit</h3>
                <p class="text-gray-600 dark:text-gray-300 mb-4">
                    Deposit checks instantly by taking a photo with your phone.
                </p>
                <ul class="space-y-2 text-sm text-gray-600 dark:text-gray-300">
                    <li class="flex items-center"><i class="fa-solid fa-check text-green-500 mr-2"></i>Photo check
                        deposit</li>
                    <li class="flex items-center"><i class="fa-solid fa-check text-green-500 mr-2"></i>Instant
                        availability</li>
                    <li class="flex items-center"><i class="fa-solid fa-check text-green-500 mr-2"></i>Deposit limits up
                        to $10K</li>
                </ul>
            </div>

            <!-- Card Management -->
            <div
                class="bg-white dark:bg-gray-800 rounded-2xl p-8 shadow-xl border border-gray-200 dark:border-gray-700 hover:shadow-2xl transition-all duration-300">
                <div
                    class="w-16 h-16 bg-teal-100 dark:bg-teal-900/30 rounded-2xl flex items-center justify-center mb-6">
                    <i class="fa-solid fa-credit-card text-2xl text-teal-600 dark:text-teal-400"></i>
                </div>
                <h3 class="text-xl font-bold text-gray-900 dark:text-white mb-3">Card Controls</h3>
                <p class="text-gray-600 dark:text-gray-300 mb-4">
                    Manage your debit and credit cards with advanced security features.
                </p>
                <ul class="space-y-2 text-sm text-gray-600 dark:text-gray-300">
                    <li class="flex items-center"><i class="fa-solid fa-check text-green-500 mr-2"></i>Lock/unlock cards
                        instantly</li>
                    <li class="flex items-center"><i class="fa-solid fa-check text-green-500 mr-2"></i>Set spending
                        limits</li>
                    <li class="flex items-center"><i class="fa-solid fa-check text-green-500 mr-2"></i>Transaction
                        alerts</li>
                </ul>
            </div>

            <!-- Budgeting Tools -->
            <div
                class="bg-white dark:bg-gray-800 rounded-2xl p-8 shadow-xl border border-gray-200 dark:border-gray-700 hover:shadow-2xl transition-all duration-300">
                <div class="w-16 h-16 bg-red-100 dark:bg-red-900/30 rounded-2xl flex items-center justify-center mb-6">
                    <i class="fa-solid fa-chart-bar text-2xl text-red-600 dark:text-red-400"></i>
                </div>
                <h3 class="text-xl font-bold text-gray-900 dark:text-white mb-3">Budgeting</h3>
                <p class="text-gray-600 dark:text-gray-300 mb-4">
                    Track spending, set budgets, and achieve your financial goals.
                </p>
                <ul class="space-y-2 text-sm text-gray-600 dark:text-gray-300">
                    <li class="flex items-center"><i class="fa-solid fa-check text-green-500 mr-2"></i>Spending
                        categories</li>
                    <li class="flex items-center"><i class="fa-solid fa-check text-green-500 mr-2"></i>Budget alerts
                    </li>
                    <li class="flex items-center"><i class="fa-solid fa-check text-green-500 mr-2"></i>Financial
                        insights</li>
                </ul>
            </div>
        </div>
    </div>
</section>
